/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class PlantTooltip
implements IRecipeSlotRichTooltipCallback {
    private final PlantEntry entry;

    public PlantTooltip(PlantEntry entry) {
        this.entry = entry;
    }

    public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        if (recipeSlotView.getRole() != RecipeIngredientRole.INPUT) {
            tooltip.add((FormattedText)this.getChanceString((ItemStack)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient()));
        }
    }

    public float getChance(ItemStack itemStack) {
        PlantDrop drop = this.entry.getDrop(itemStack);
        return switch (drop.getDropKind()) {
            case PlantDrop.DropKind.chance -> drop.getChance();
            case PlantDrop.DropKind.weight -> (float)drop.getWeight() / (float)this.entry.getTotalWeight();
            case PlantDrop.DropKind.minMax -> Float.NaN;
            default -> 0.0f;
        };
    }

    public int[] getMinMax(ItemStack itemStack) {
        PlantDrop drop = this.entry.getDrop(itemStack);
        return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
    }

    private Component getChanceString(ItemStack itemStack) {
        String toPrint;
        float chance = this.getChance(itemStack);
        if (Float.isNaN(chance)) {
            int[] minMax = this.getMinMax(itemStack);
            toPrint = minMax[0] + (String)(minMax[0] == minMax[1] ? "" : " - " + minMax[1]);
        } else {
            toPrint = String.format("%2.2f", Float.valueOf(chance * 100.0f)).replace(",", ".") + "%";
        }
        return Component.literal((String)toPrint);
    }
}

